//
//  MCQueryBuilderView.h
//  MCApplication
//
//  Created by Michael Clark on 16/08/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MCView.h"

@class MCQueryCriteriaBrowserView, MCQueryExpressionView;
@class MCPDocument;

@interface MCQueryBuilderView : NSView {
	IBOutlet NSSplitView*                   splitView;
	IBOutlet MCQueryCriteriaBrowserView*    criteriaView;
	IBOutlet MCQueryExpressionView*         expressionView;
	
	
	NSDictionary*              config;
	
	MCPDocument*   __document;
}



///// ACCESSORS /////
- (MCQueryCriteriaBrowserView *)criteriaView;
- (MCQueryExpressionView *)expressionView;

- (NSString *)criteriaSubsetIdentifier;
- (NSString*)entityName;
- (NSDictionary*)qualifierConfig;

// Minimum keys: EntityName, CriteriaSubsetIdentifier
- (NSDictionary *)config;
- (void)setConfig:(NSDictionary *)aConfig;

- (MCPDocument *)document;
- (void)setDocument:(MCPDocument *)aDocument;
@end
